#include<cstdio>
#include<cstring>
#include<algorithm>
#include<iostream>
#include<cmath>
#include<set>
#include<vector>
using namespace std;
const int N = 4941; // number of demands
const double facility_cost = 20;
const int dim = 3; // dimension 
double dis[N + 1]; // distance
double cost = 0; // total cost
vector<int> Fset; // the set of open facility
struct demand {
	int t;  // arrive time
	double x[dim + 1]; // point 
	double r; // needed in MP algorithm
}D[N + 1];
double g[N + 4][N + 4]; // g[i][j] represents the distance between i-th point and j-th point

inline double dist(demand &d1, demand &d2) {
	double ret = 0;
	for (int i = 1; i <= dim; i++)
		ret += (d1.x[i] - d2.x[i]) * (d1.x[i] - d2.x[i]);
	return sqrt(ret);
}

bool cmp(demand a, demand b) {
	return a.r < b.r;
}


int main() {
	freopen("USpowerGrid.txt", "r", stdin);
	for (int i = 1; i <= N; i++)
		for (int j = i + 1; j <= N; j++) {
			int a, b, c;
			scanf("%d%d%d",&a, &b, &c);
			g[a][b] = g[b][a] = c;
		}
	for (int i = 1; i <= N; i++) {
		D[i].t = i;
		for (int j = 1; j <= N; j++)
			dis[j] = g[i][j];
		sort(dis + 1, dis + N + 1); 
		double total = 0;
		double r = 0;
		for (int j = 1; j <= N; j++) {
			total += dis[j];
			r = (total + facility_cost) / j;
			if ((r <= dis[j + 1]  && r >= dis[j]) || j == N) {
				D[i].r = r;   
				break;
			}
		}
	}
	sort(D + 1, D + N + 1, cmp);
	for (int i = 1; i <= N; i++) {
		int siz = Fset.size();
		bool flag = 0;
		for (int j = 0; j < siz; j++) {
			int pos = Fset[j];
			if (g[pos][D[i].t] <= 2 * D[i].r) {
				flag = 1;
				break;
			}
		}
		if (!flag) 
			Fset.push_back(D[i].t);
	}
	freopen("USpowerGrid10.txt", "w", stdout);
	for (int i = 1; i <= N; i++) {
		int siz = Fset.size();
		double connect_cost = 1e9;
		int opt;
		for (int j = 0; j < siz; j++) {
			int pos = Fset[j];
			double dis = g[pos][D[i].t];
			if (connect_cost > dis) {
				connect_cost = dis;
				opt = pos;
			}
		}
		cost += connect_cost;
		printf("%d %d\n", D[i].t, opt);
	}
	cost += Fset.size() * facility_cost;
	printf("%.6f\n", cost);
	printf("%lu\n", Fset.size());
}